#!/usr/bin/env python3

# Splitter for 'ABC123' into ['ABC', '123']
from itertools import groupby
numbers = '0123456789'
def splitter(s):
    return [''.join(g) for _, g in groupby(s, numbers.__contains__)]


Notes = ['C', 'C#', 'D', 'D#', 'E', 'F', 'F#', 'G', 'G#', 'A', 'A#', 'B']
hash_count = {}
for i,c in enumerate(Notes):
    hash_count[i] = +('#' in c)


n = int(input())
l,r = [Notes.index(c) + 12 * int(o) for c,o in map(splitter, input().split())]
A   = [Notes.index(c) + 12 * int(o) for c,o in map(splitter, input().split())]

# Transpose down as much as possible
Amin = min(A)
A = [a - Amin + l for a in A]
Amax = max(A)

# Assert there exists a solution
assert Amax <= r

mini = 10**18
ways = 0
for shift in range(12):
    cost = sum(hash_count[(t + shift) % 12] for t in A)
    count = (r - (Amax + shift)) // 12 + 1

    if count > 0 and cost <= mini:
        ways = count + (ways if cost == mini else 0)
        mini = cost

print(mini, ways)
